/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.traits;

import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class KineticModifier
extends NoLevelsModifier {
    public void failedEntityHit(IToolStackView tool, int level, ToolAttackContext context) {
        ServerPlayer sp = (ServerPlayer)context.getPlayerAttacker();
        if (sp != null) {
            this.chargeInventoryItem(sp);
        }
    }

    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        ServerPlayer sp = (ServerPlayer)context.getPlayerAttacker();
        if (sp != null) {
            this.chargeInventoryItem(sp);
        }
        return 0;
    }

    public void afterBlockBreak(IToolStackView tool, int level, ToolHarvestContext context) {
        ServerPlayer sp = context.getPlayer();
        if (sp != null && !sp.f_19853_.f_46443_) {
            this.chargeInventoryItem(sp);
        }
    }

    private void chargeInventoryItem(ServerPlayer sp) {
        Optional itemHandlerCap = sp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        if (!this.chargeHandler(itemHandlerCap) && Mekanism.hooks.CuriosLoaded) {
            this.chargeHandler(CuriosIntegration.getCuriosInventory((LivingEntity)sp));
        }
    }

    private boolean chargeHandler(Optional<? extends IItemHandler> itemHandlerCap) {
        if (itemHandlerCap.isPresent()) {
            IItemHandler itemHandler = itemHandlerCap.get();
            int slots = itemHandler.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (stack.m_41619_() || !this.provideEnergy(EnergyCompatUtils.getStrictEnergyHandler((ItemStack)stack))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean provideEnergy(@Nullable IStrictEnergyHandler energyHandler) {
        if (energyHandler == null) {
            return false;
        }
        FloatingLong energyToGive = FloatingLong.create((long)20L);
        energyHandler.insertEnergy(energyToGive, Action.EXECUTE);
        return true;
    }
}

